#include "translate.h"

static const t_unicode cp866_c1_chars[] = {
0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, /* 0x80-0x87 */
0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f, /* 0x88-0x8F */
0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, /* 0x90-0x97 */
0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f, /* 0x98-0x9F */
};
struct char_set cp866_c1 = {
	1,
	CHARS(cp866_c1_chars),
	0, "", 0, 32,
};

static const t_unicode cp866_g1_chars[] = {
0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, /* 0xA0-0xA7 */
0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f, /* 0xA8-0xAF */
0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556, /* 0xB0-0xB7 */
0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510, /* 0xB8-0xBF */
0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f, /* 0xC0-0xC7 */
0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567, /* 0xC8-0xCF */
0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b, /* 0xD0-0xD7 */
0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580, /* 0xD8-0xDF */
0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, /* 0xE0-0xE7 */
0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f, /* 0xE8-0xEF */
#if 0
0x0401, 0x0451, 0x0404, 0x0454, 0x0407, 0x0457, 0x040e, 0x045e, /* 0xF0-0xF7 */
0x00b0, 0x2219, 0x00b7, 0x221a, 0x2116, 0x00a4, 0x25a0, 0x00a0, /* 0xF8-0xFF */
#else
0x0401, //CYRILLIC CAPITAL LETTER IO
0x0451, //CYRILLIC SMALL LETTER IO
0x2265, //GREATER-THAN OR EQUAL TO
0x2264, //LESS-THAN OR EQUAL TO
0x2320, //TOP HALF INTEGRAL
0x2321, //BOTTOM HALF INTEGRAL
0x00f7, //DIVISION SIGN
0x2248, //ALMOST EQUAL TO
0x00b0, //DEGREE SIGN
0x2219, //BULLET OPERATOR
0x00b7, //MIDDLE DOT
0x221a, //SQUARE ROOT
0x207f, //SUPERSCRIPT LATIN SMALL LETTER N
0x00b2, //SUPERSCRIPT TWO
0x25a0, //BLACK SQUARE
0x00a0, //NO-BREAK SPACE
#endif
};
struct char_set cp866_g1 = {
	1,
	CHARS(cp866_g1_chars),
	0, "", 0, 96,
};

struct char_set cp866 = {
	.c0 = &ibm_ascii_c0,
	.g0 = &ibm_ascii_g0,
	.c1 = &cp866_c1,
	.g1 = &cp866_g1,
	.names = { "cp866", 0 },
};

CONSTRUCTOR(static void init(void))
{
	register_charset(&cp866);
}
