/* 
 * (C) Copyright 1992, ..., 2002 the "DOSEMU-Development-Team".
 *
 * for details see file COPYING in the DOSEMU distribution
 */

/***********************************************************************
  event handling: read parameters and put event in driver queue
 ***********************************************************************/

#include "events.h"
#include "midid.h"
#include "io.h"
#include "stats.h"
#include "emulation.h"
#include "device.h"
#include <stdio.h>
#include <linux/soundcard.h>

#define EOX 0xf7

void do_noteoff(int chn)
{
	int note, vel;
	note = getbyte_data();
	if (note<0) return; /* Return at error */
	getbyte_next();
	vel = getbyte_data();
	if (vel<0) return;
	getbyte_next();
	if (debug)
		fprintf(stderr, "note_off(chn=%i,note=%i,vel=%i)\n", chn, note, vel);
	dev_noteoff(chn, note, vel);
}

void do_noteon(int chn)
{
	int note, vel;
	note = getbyte_data();
	if (note<0) return;
	getbyte_next();
	vel = getbyte_data();
	if (vel<0) return;
	getbyte_next();
	if (debug)
		fprintf(stderr, "note_on(chn=%i,note=%i,vel=%i)\n", chn, note, vel);
	dev_noteon(chn, note, vel);
}

void do_notepressure(int chn)
{
	/* Polyphonic key pressure, note pressure */
	int note, vel;
	note = getbyte_data();
	if (note<0) return;
	getbyte_next();
	vel = getbyte_data();
	if (vel<0) return;
	getbyte_next();
	if (debug)
		fprintf(stderr, "note_pressure(chn=%i,note=%i,vel=%i)\n", chn, note, vel);
	dev_notepressure(chn, note, vel);
}

void do_program(int chn)
{
	/* Program change */
	int pgm;
	pgm = getbyte_data();
	if (pgm<0) return;
	getbyte_next();
	if (statistics)
		stats_addprogram(pgm);
	if (debug)
		fprintf(stderr, "change_program(chn=%i,pgm=%i)\n", chn, pgm);
	/* Use mapping for MT32 <-> GM emulation (imap[]) */
	dev_program(chn, imap[pgm]);
}

void do_channelpressure(int chn)
{
	/* Channel pressure */
	int vel;
	vel = getbyte_data();
	if (vel<0) return;
	getbyte_next();
	if (debug)
		fprintf(stderr, "control_change(chn=%i,vel=%i)\n", chn, vel);
	dev_channelpressure(chn, vel);
}

void do_bender(int chn)
{
	/* Pitch wheel, bender */
	int pitch;
	pitch=getbyte_data();
	if (pitch<0) return;
	getbyte_next();
	if (getbyte_data()<0) return;
	pitch += getbyte_data() << 7;
	getbyte_next();
	if (debug)
		fprintf(stderr, "bender(chn=%i,pitch=%i)\n", chn, pitch);
	dev_bender(chn, pitch);
}

void do_sysex(void)
{
#define SYSEX_BUF_LEN 1024
char buf[SYSEX_BUF_LEN];
int ch, len = 0;
	buf[len++] = MIDI_SYSTEM_PREFIX;
	ch = getbyte();
	if (debug)
		fprintf(stderr,"Sysex for vendor ID#%x\n",ch);
	while(1) {
		buf[len++] = ch;
		getbyte_next();
		if (ch == EOX) {
			if (debug)
				fprintf(stderr,"End of SysEx, len=%i\n", len);
			if (imap == imap_default)
				dev_sysex(buf, len);
			return;
		}
		ch = getbyte();
		if (ch<0 || len >= SYSEX_BUF_LEN) return;
		if (debug)
			fprintf(stderr,"Sysex: %x\n",ch);
	}
}

void do_controlchange(int chn)
{
	int control;
	int value;
	control = getbyte_data();
	if (control<0) return;
	getbyte_next();
	value = getbyte();
	if (value<0) return;
	getbyte_next();
	if (debug)
		fprintf(stderr, "control_change(chn=%i,control=%i,val=%i)\n",
                        chn, control, value);
	dev_control(chn, control, value);
}

