#!/bin/sh
# RAV AntiVirus for the Courier MTA install script.
# Author: RAV Development Team <ravteam@ravantivirus.com>
# http://www.ravantivirus.com


main()
{
rpm_detect
clear
welcome
interface
echo "Press ENTER to continue..."
read x
main
}

welcome()
{
cat << EOF

				Welcome 

 This script will help you install the RAV AntiVirus for Courier product
 Please note that you must have root privileges in order to install these packages.

 Currently the following modules are present on your system:
 RAV AntiVirus core version: $RAV_CORE_INSTALLED
 RAV AntiVirus mail scanning daemon version: $RAV_DAEMON_INSTALLED
 RAV AntiVirus filter for Courier MTA version: $RAV_COURIER_INSTALLED
EOF
}

interface()
{
cat << EOF


Please select one of the actions below:

 1. see the License Agreement for the RAV AntiVirus products   (very important)
 2. check for hardware and software requirements
 3. full install/upgrade					  (recommended)
 4. RAV AntiVirus core	     (RAV scanning kernel and virus signature database)
 5. RAV AntiVirus mail scanning daemon		(ravmd is needed by ravcourier)
 6. RAV AntiVirus filter for Courier (antivirus and content filter for Courier)
 0. exit without doing anything

EOF

echo "Component? [1 2 3 4 5 6 0] $c" 
read component
case "$component" in
0|[XxQq]) exit 0  ;;
1) license ;;
2) requirements ;;
3) install_full  ;;
4) install_ravcore ;;
5) install_ravmd     ;;
6) install_ravcourier  ;;
*) refresh ;;
esac
}

refresh()
{
clear
welcome
interface
}

rpm_detect()
{
RPM_VER=`rpm --version 2>/dev/null`
if [ "${RPM_VER}x" = "x" ];then
  echo "RedHat Package Management (rpm) has not been found on your system"
  echo "Please download the RAV AntiVirus tar-gzipped binary version from our website "
  echo " http://www.ravantivirus.com"
  exit 0
fi

RAV_CORE_INSTALLED=`rpm -q ravcore 2>/dev/null | awk 'BEGIN { FS = "-" } ; { print $2 "." $3 }'`
if [ "${RAV_CORE_INSTALLED}x" = ".x" ];then
  export RAV_CORE_INSTALLED="not installed"
fi

RAV_DAEMON_INSTALLED=`rpm -q ravmd 2>/dev/null | awk 'BEGIN { FS = "-" } ; { print $2 "." $3}'`
if [ "${RAV_DAEMON_INSTALLED}x" = ".x" ];then
  export RAV_DAEMON_INSTALLED="not installed"
fi

RAV_COURIER_INSTALLED=`rpm -q ravcourier 2>/dev/null | awk 'BEGIN { FS = "-" } ; { print $2 "." $3}'`
if [ "${RAV_COURIER_INSTALLED}x" = ".x" ];then
  export RAV_COURIER_INSTALLED="not installed"
fi
}

requirements()
{
reqs_sw
reqs_hw
clear
less --quit-at-eof << EOF

 This screen enables you to compare the minimal system on which our product 
works with your own system.
 Please note that if you want to use RAV AntiVirus for Courier on a server 
with 10000+ mailboxes you will have to adjust your hardware acordingly.


minimal software requirements     |  you have:
                                  |
Linux kernel version   2.0        |  ${SYS_KERNEL}
glibc version          2.1.3      |  ${SYS_GLIBC}
rpm version            3.0        |  ${SYS_RPM}

minimal hardware requirements:

compatible Intel CPU              | $SYS_CPU_TYPE
processor speed       150 MHz     | $SYS_CPU_SPEED
RAM                   32  Mb      | $SYS_MEM




EOF

refresh
}

reqs_sw()
{
GLIBC_1=`ls -al /lib/ld-linux.so.1* 2> /dev/null | awk 'BEGIN { FS = "-> " } ; { print $2 }'`
GLIBC_2=`ls -al /lib/ld-linux.so.2* 2> /dev/null | awk 'BEGIN { FS = "-> " } ; { print $2 }'`

SYS_GLIBC="$GLIBC_2 $GLIBC_1"
SYS_RPM=`rpm --version`
SYS_KERNEL=`uname --release`

}

reqs_hw()
{
SYS_CPU_TYPE=`cat /proc/cpu* 2>/dev/null | grep "model name" |  awk 'BEGIN { FS = ":" } ; { print $2 }' `
SYS_CPU_SPEED=`cat /proc/cpu* 2>/dev/null | grep "cpu.*Hz" |  awk 'BEGIN { FS = ":" } ; { print $2 }' `
SYS_MEM1=`free -m | grep -i 'mem' | awk ' { print $2 } ' `
SYS_MEM2=`free -m | grep -i 'mem' | awk ' { print $3 } ' `
SYS_MEM=" ${SYS_MEM1}Mb total and ${SYS_MEM2}Mb used" 
}

install_full()
{
install_ravcore
install_ravmd
install_ravcourier
}

install_ravmd()
{
if  [ "${RAV_CORE_INSTALLED}" = "not installed" ];then
 install_ravcore
fi

echo "Installing RAV AntiVirus mail scanning daemon (ravmd)"
rpm --upgrade --force -v --hash ravmd-*.rpm
RAV_DAEMON_INSTALLED="installed"
}

install_ravcourier()
{
if  [ "${RAV_DAEMON_INSTALLED}" = "not installed" ];then
 install_ravmd
fi

echo "Installing RAV AntiVirus filter for Courier MTA (ravcourier)"
rpm --upgrade --force -v --hash ravcourier-*.rpm
RAV_COURIER_INSTALLED="installed"
}

install_ravcore()
{
echo "Installing RAV AntiVirus scanning engine (ravcore)"
rpm --upgrade --force -v --hash ravcore-*.rpm
RAV_CORE_INSTALLED="installed"
}

license()
{

clear
less --quit-at-eof << EOF

License Agreement
SOFTWARE PRODUCT: RAV AntiVirus for Mail Servers
Copyright since 1995 (C) GeCAD Software SRL - All Rights Reserved
RAV ANTIVIRUS is a trademark of GeCAD Software SRL


IMPORTANT. READ CAREFULLY: This GeCAD SOFTWARE LICENSE AGREEMENT 
(hereinafter referred to as "SLA") is a legal agreement between you (either an individual or a 
single entity) and GeCAD Software SRL (hereinafter referred to as "GeCAD") for the GeCAD 
SOFTWARE PRODUCT (hereinafter referred to as "SOFTWARE PRODUCT" identified 
above, which includes computer software and associated media and printed materials (if any), 
and may include online or electronic documentation. 

By installing, copying, or otherwise using the SOFTWARE PRODUCT, you agree to be bound 
by the terms of this SLA. If you do not agree with the present SLA, you are not authorized to 
install, to copy or to otherwise use the SOFTWARE PRODUCT. Obtaining the ownership of 
the material support of the software only shall not grant you any right to install, to copy, to use, 
or to otherwise exploit the SOFTWARE PRODUCT.

The SOFTWARE PRODUCT is not free software. Therefore you, as Licensee, hereby agree to 
pay the license fee, per copy of the SOFTWARE PRODUCT acquired. The license granted by 
this SLA commence on the date that you install, copy or otherwise first use the SOFTWARE 
PRODUCT. The license shall be perpetual, except if otherwise expressly provided within the 
license type you acquire.

The SOFTWARE PRODUCT is licensed, not sold. The acceptance of any purchase order 
placed by you is expressly made conditioned on your assent to the terms set forth herein, and 
not those set by you within the purchase order. All rights of any kind, which are not expressly 
granted by the present this SLA, are entirely and exclusively reserved to and by GeCAD.

1.	Grant of License

a. RAV AntiVirus for Mail Servers - Standard License 

Except as set forth below, this license grant you the non-exclusive and non-transferable right to 
install and use the copy of the SOFTWARE PRODUCT on one server for electronic mail only, 
for the purpose of protecting as many mailboxes and domains as expressly set by purchase 
document. Any new mailbox and/or domain, exceeding the number allowed by the present SLA 
and the purchase document, may be protected or other way be served by the SOFTWARE 
PRODUCT only after payment of the appropriate license fee.

Within the present SLA "domain" is understood as the string of characters following the "@" 
sign. Any modification of the string, including without limitation the reversal, addition, 
removal, replacement etc of one or more characters, represents a new and distinctive domain 
(for example, within username@gecadsoftware.com, there is a different domain than within 
username@mail.gecadsoftware.com). 


The GeCAD SOFTWARE PRODUCT utilizes content that is updated from time to time (such 
as virus definitions). This are referred to as "content updates". The standard license includes one 
year of content updates. GeCAD has the right to discontinue creating, releasing and providing 
content updates for or related to the SOFTWARE PRODUCT version acquired by you in case 
GeCAD release a new version of the SOFTWARE PRODUCT. In such case, during the first 
year of SLA or during the UpEx year, you may obtain without any charge the newly released 
version (to replace the one aquired previously by you), as well as free content updates related to 
the newly released version of the SOFTWARE PRODUCT, provided that you previously have 
activated the new version of SOFTWARE PRODUCT with the activation key received from 
GeCAD. This upgrade to new version will not extend the content update period of one year. 
These represent the general rules of granting content updates under the present SLA.

b. RAV AntiVirus for Mail Servers - Evaluation license and registration

The SOFTWARE PRODUCT is not free software. This license grants you the non-exclusive 
and non-transferable right to install and use the copy of the SOFTWARE PRODUCT on one 
computer only, for evaluation purposes, the SOFTWARE PRODUCT without charge for a 
period of 30 (thirty) days. You are also bound to the obligations provided by Article 1 point a) 
above. 

Unregistered and unauthorized use of the software after the 30 days evaluation period represents 
a violation of GECAD's copyright as well as a violation of Romanian and international 
copyright laws.

During the evaluation period you are hereby licensed, without charge:
(i)  to use for evaluation purposes only the Evaluation Version of the SOFTWARE PRODUCT; 
it is expressly excluded and forbidden any other type of use, including but not limited to, 
administrative, commercial or productive support for your and/or third party's business 
activities;
(ii) to give exact copies of this evaluation version of the software  personally to anyone, except 
for the purpose of extending their 30 (thirty) day evaluation period;
(iii) to distribute exact copies of this evaluation version of the software, if done exclusively 
through electronic channels.

There is no charge for any of the above. You are specifically prohibited from charging, 
requesting donations or otherwise asking or receiving economical benefits for any such copies, 
however made, and from distributing the software and/or documentation with other products 
(commercial or otherwise) without prior GeCAD written permission. 

Upon expiration of the evaluation period you are obliged to uninstall and destroy all 
SOFTWARE PRODUCT's copies. It is strictly forbidden to partially or totally, temporary or 
definitively, reproduce or retain SOFTWARE PRODUCT's copies, as well as to use for any 
purposes, to distribute or to conduct any other activity concerning SOFTWARE PRODUCT's 
copies upon expiration of the evaluation period. Failure to comply with obligation herein 
provided represents a violation of copyrights and copyright laws and shall be subject of civil, 
administrative and/or criminal consequences, procedures and/or punishments.

c. RAV AntiVirus for Mail Servers - Educational License 

You may use the SOFTWARE PRODUCTS acquired in special conditions (usually lower price) 
as Educational License ONLY if you are an educational institute or an academic personnel, 
within the terms and conditions hereunder, ONLY on educational purpose computers. You are 
not allowed to use the SOFTWARE PRODUCT for administrative, commercial, accounting or 
for any non-educational activities. You are also bound to the obligations provided by Article 1 
point a) above.

Therefore, the right to use the SOFTWARE PRODUCT acquired under an Educational License 
is granted, within the general terms and conditions provided by the present License as well as 
within the terms and conditions of the present Article 1 point c), to the following:
(i)	to academic institutions in conjunction with educational activities such as teaching, 
research;
(ii)	to academic personnel in conjunction with teaching and learning activities.

You hereby agree to demonstrate the status of educational or of academic personnel institute by 
sending specific documents to GeCAD or to a GeCAD Partner if required by GeCAD or by a 
GeCAD Partner. 
 
d. RAV AntiVirus for Mail Servers - Subscription License

Subscription license is a temporary license. You may use the SOFTWARE PRODUCT acquired 
as Subscription License ONLY during the subscription period as expressly determined within 
the purchasing documents. During this period you may download and use the latest version of 
the SOFTWARE PRODUCT and you may also benefit of the content update. Once the 
subscription expires, you have to uninstall and destroy all SOFTWARE PRODUCT 's copies. 
Use of SOFTWARE PRODUCT acquired under a Subscription License after the subscription 
period represents a violation of copyright and copyright laws. During the subscription period 
you are also bound to the obligations provided by Article 1 point a) above. 

e.   RAV AntiVirus for Mail Servers - Annual Update Extension - UpEx

After the expiration of the first year of content update benefits as provided by the standard 
license within Article 1 a), you may obtain content updates by purchasing Update Extension 
(UpEx) for successive and consecutive periods of one year each. During the UpEx, the general 
rules which are provided by Article 1 a) shall apply.

2.     General rights and limitations

a) Storage
You may also store a copy of the SOFTWARE PRODUCT on one storage device only, 
for back-up purposes. 

b) Derivative works
GeCAD reserves all rights not expressly granted by the present SLA including, without 
limitation, modification rights, translation rights, rights to source code etc. You are not allowed 
to make, or to allow being made any kind of derivative works products, from GeCAD 
SOFTWARE PRODUCTS concerned by the present SLA. Consequently, you are strictly 
forbidden to add, change, modify, erase features and / or interfaces related to the SOFTWARE 
PRODUCT, or to any other way create or alter such features and / or interfaces. You are also 
forbidden to allow other parties to add, change, modify, erase features and / or interfaces related 
to the SOFTWARE PRODUCT, or to any other way create or alter such features and / or 
interfaces.
In case you want to have the right to make any kind of derivative works from the SOFTWARE 
PRODUCT, you must obtain GeCAD's express, prior and written approval in this respect. 

c) Reverse Engineering
You may not modify, translate, reverse engineer, recompile, disassemble or create derivative 
works based on the SOFTWARE PRODUCT, or any portion thereof.

d) Copying
You may not copy the Software or Documentation except as expressly provided by this SLA.

e) Transfer
You may not sell, loan, rent, lease or any other way transfer the SOFTWARE PRODUCT or 
Documentation. 

f) Proprietary Notices
You may not remove, add or modify any proprietary notices, labels or marks on the Software or 
Documentation.

g) Use of GeCAD's name
You may not use GeCAD's name(s), logo(s), or trademark(s) in any manner including, without 
limitation, in your advertising or marketing materials.

You hereby undertake yourself not to use any name or trademark confusingly similar to an 
GeCAD or to a GeCAD licensed third party's trademark, trade name and/or product name. You 
hereby undertake yourself not to interfere with or diminish GeCAD right, title and/or interest in 
GeCAD or licensed third party's trademark(s), trade name(s) or Product name(s).

3. Termination

The license will automatically terminate if you fail to comply with the obligation and limitations 
herein described. On termination you must destroy all copies of the Software and 
Documentation and all its component parts. There shall be no refund or adjustment for amounts 
paid by you to GeCAD for SOFTWARE PRODUCT(s) destroyed in accordance with the 
present article.The provisions of the present SLA which by their nature extend beyond the 
termination date of the SLA will survive and remain in effect and enforceable until all 
obligations are fully satisfied. 

4.	Limited warranty

a.	Media
GeCAD warrants that the media containing the SOFTWARE PRODUCT, if provided by 
GeCAD, is free from defects in material and workmanship and will so remain for 30 (thirty) 
days from the date you acquired the SOFTWARE PRODUCT. GeCAD's sole liability, and your 
sole remedy, for any breach of this warranty shall be to replace your defective media. Replaced 
media shall be covered by this limited warranty for 30 (thirty) days after the date of shipment to 
you of the replaced media.

b.	Software Product
This software and the accompanying files are provided "as is" and without warranties as to 
performance or merchantability or any other warranties whether expressed or implied. Because 
of the various hardware and software environments into which the SOFTWARE PRODUCT 
may be put, no warranty or fitness for a particular purpose is offered. 

Good data processing procedure dictates that any program should be thoroughly tested with 
non-critical data before relying on it. The user hereby agrees to assume the entire risk of using 
the program.

GeCAD will use reasonable commercial efforts to provide solutions for any reported 
malfunctions. THIS IS A LIMITED WARRANTY AND IT IS THE ONLY WARRANTY 
MADE BY GECAD. GECAD MAKES NO OTHER WARRANTY, REPRESENTATION, OR 
CONDITION, EXPRESS OR IMPLIED, AND EXPRESSLY DISCLAIMS THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, 
AND NO INFRINGEMENT OF THIRD PARTY RIGHTS. THE DURATION OF IMPLIED 
WARRANTIES OR CONDITIONS, INCLUDING WITHOUT LIMITATION, 
WARRANTIES OR CONDITIONS OF MERCHANTABILITY AND OF FITNESS FOR A 
PARTICULAR PURPOSE, IS LIMITED TO THE ABOVE LIMITED WARRANTY 
PERIOD; NO GECAD PARTNER, DISTRIBUTOR, OR EMPLOYEE IS AUTHORIZED TO 
MAKE ANY MODIFICATIONS, EXTENSIONS, OR ADDITIONS TO THIS WARRANTY. 
If you make any modifications to the SOFTWARE PRODUCT during the warranty period, if 
the media is subjected to accident, abuse, or improper use, or if you violate the terms of this 
SLA, then this warranty shall immediately be terminated. This warranty shall not apply if the 
SOFTWARE PRODUCT is used on or in conjunction with hardware or software other than the 
unmodified version of hardware and software which the Software was designed to be used as 
described in the Documentation.

NO warranty refers to evaluation period.

5.	Limitation of liability

UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, 
CONTRACT, OR OTHERWISE, SHALL GECAD OR ITS PARTNERS OR DISTRIBUTORS 
BE LIABLE TO YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, 
INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, 
WITHOUT LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, 
COMPUTER FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL 
DAMAGES OR LOSSES, OR FOR ANY DAMAGES IN EXCESS OF GECAD'S LIST 
PRICE FOR A LICENSE TO THE SOFTWARE AND DOCUMENTATION, EVEN IF 
GECAD SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, 
OR FOR ANY CLAIM BY ANY OTHER PARTY.

6.	Copyright

All intellectual property rights in and to the SOFTWARE PRODUCT and Documentation are 
property of GeCAD. All intellectual property rights related to the SOFTWARE PRODUCT 
remain property of GeCAD. Romanian copyright law, local copyright law and international 
treaties protect the SOFTWARE PRODUCT as well as the rights related to it.

7.	Miscellaneous 

This SLA represents the complete agreement concerning this license between the parties and 
supersedes all prior agreements and representations between them. This SLA may be amended 
only in writing executed by both parties. If any provision of this SLA is held to be 
unenforceable for any reason, such provision shall be reformed only to the extent necessary to 
make it enforceable and the remaining provisions of this SLA shall remain in full force and 
effect.

This SLA will be governed by the law of the country of copyright holder.

Neither this SLA, nor any terms and conditions contained herein, shall be construed as creating 
a partnership, joint venture or agency relationship or as granting a franchise.

You shall, at your own expense, promptly obtain and arrange for the maintenance of all 
mandatory government approvals, if any, and comply with all applicable local laws and 
regulations as may be necessary for your performance under this SLA.



















EOF

refresh
}

main
