#!/bin/sh
#
# DSPAM install script for RHEL 5,6,7
# Written by Eric C. Broch of White Horse Technical Consulting, January 26, 2015
#
# Use this script at your own risk. If you do use it and the bottom drops out of
# your world, I will accept no responsibilty.
#

# Check if release file is present
if [ ! -f /etc/redhat-release ]; then
   echo "Error getting EL release. Exiting..."
   exit 1
fi

# Get release
yumcmd="yum -y install yum-priorities"
epelrel=
dbserv=
release=`cat /etc/redhat-release | tr -d [:alpha:] | cut -d"." -f1 | tr -d ' '`
if [ "$release" = "5" ] || [ "$release" = "6" ]; then
   epelrel=epel-release-5-4.noarch.rpm
   dbserv=mysql-server
   if [ "$release" = "6" ]; then
      epelrel=epel-release-6-8.noarch.rpm
      yumcmd="yum -y install yum-plugin-priorities"
   fi   
elif [ "$release" = "7" ]; then
   epelrel=epel-release-7-5.noarch.rpm
   dbserv=mariadb-server
   yumcmd="yum -y install yum-plugin-priorities"
else
   echo "Can't determine CentOS release ($dbserv)"
   exit 1
fi

#Install yum priorities
$yumcmd

MYSQLPW=
# Check whether DB (mysql/mariadb) server is installed, if not, install it or exit.
echo "Checking $dbserv..."
rpm -qa | grep $dbserv > /dev/null 2>&1
if [ "$?" != "0" ]; then
   echo "$dbserv not installed"
   read -p "Install $dbserv? [y/n] :" input
   if [ "$input" = "Y" ] || [ "$input" = "y" ]; then
      yum -y install $dbserv
   else
      echo "Exiting script. No DB server installed"
      exit 1
   fi
else
   echo "$dbserv present"
fi

# Enable DB server, exit on error
echo "Enabling $dbserv..."
if [ "$release" = "5" ] || [ "$release" = "6" ]; then
   chkconfig mysqld on
fi
if [ "$release" = "7" ]; then
  systemctl enable mariadb.service
fi
if [ "$?" != "0" ]; then
   echo "$dbserv daemon not enabled. Exiting..."
   exit 1
fi

# Start DB server, exit on error
echo "Starting $dbserv..."
if [ "$release" = "5" ] || [ "$release" = "6" ]; then
   service mysqld start
fi
if [ "$release" = "7" ]; then
  systemctl start mariadb.service
fi
if [ "$?" != "0" ]; then
   echo "$dbserv not started. Exiting..."
   exit 1
fi

# mysql secure install
read -p "Run MySQL Secure Install [Y/N] : " yesno
if [ "$yesno" = "Y" ] || [ "$yesno" = "y" ]; then
   mysql_secure_installation
fi

# Get DB password for administrator.
if [ -z "$MYSQLPW" ]; then
   read -p "Enter $dbserv admin password to create dspam db: " MYSQLPW
fi

# Check if entered password is valid.
mysqladmin status -uroot -p$MYSQLPW > /dev/null 2>&1
if [ "$?" != "0" ]; then
   echo "Bad $dbserv administrator password. Exiting..."
   exit 1
fi

# Check if destroying dspam database is desired
read -p "If there is a dspam database, you are about to destroy it and create a new one. Proceed? [Y/N]: " input
if [ "$input" != "Y" ] && [ "$input" != "y" ]; then
   echo "Exiting..."
   exit 1
fi

# Create dspam with correct permissions
mysqladmin drop dspam -uroot -p$MYSQLPW
mysqladmin create dspam -uroot -p$MYSQLPW
mysqladmin -uroot -p$MYSQLPW reload
mysqladmin -uroot -p$MYSQLPW refresh

echo "GRANT ALL ON dspam.* TO dspam@localhost IDENTIFIED BY 'p4ssw3rd'" | mysql -uroot -p$MYSQLPW
mysqladmin -uroot -p$MYSQLPW reload
mysqladmin -uroot -p$MYSQLPW refresh

mysql -uroot -p$MYSQLPW dspam < dspamdb.sql
mysqladmin -uroot -p$MYSQLPW reload
mysqladmin -uroot -p$MYSQLPW refresh

# Install EPEL Repository if not installed
if [ ! -f /etc/yum.repos.d/epel.repo ]; then
   echo "Installing EPEL repository..."
   ARCH=`uname -m`
   rpm -Uvh http://dl.fedoraproject.org/pub/epel/$release/$ARCH/e/$epelrel
   if [ "$?" != "0" ]; then
      echo "Error downloading EPEL repo. Exiting..."
      exit 1
   fi
else
   echo "EPEL present on system. Continuing..."
fi

# Install dspam rpm's if not installed.
echo "Checking for dspam installation..."
rpm -qa | grep dspam > /dev/null 2>&1
if [ "$?" != "0" ]; then
   yum -y install dspam
fi
echo "Checking for dspam-client installation..."
rpm -qa | grep dspam-client > /dev/null 2>&1
if [ "$?" != "0" ]; then
   yum -y install dspam-client
fi
echo "Checking for dspam-mysql installation..."
rpm -qa | grep dspam-mysql > /dev/null 2>&1
if [ "$?" != "0" ]; then
   yum -y install dspam-mysql
fi

# Change permissions on and place proper files necessary to run dspam daemon
chmod 777 /var/run/dspam

echo "Renaming old dspam.conf -> dspam.conf.bak"
cp -p /etc/dspam.conf /etc/dspam.conf.bak
echo "Replace old dspam.conf with new dspam.conf"
cp -p  dspam.conf /etc/dspam.conf
echo "Change permissions on dspam.conf"
chmod 744 /etc/dspam.conf

# Implement dspam for all domains
read -p "Implement dspam for domains? [Y/N]: " input
if [ "$input" = "Y" ] || [ "$input" = "y" ]; then
   domdir=/home/vpopmail/domains
   for folder in `ls $domdir`; do
      if [ -d $domdir/$folder ]; then
         read -p "Add dspam functionality to $folder [Y]: " input1
         if [ "$input1" = "Y" ] || [ "$input1" = "y" ]; then
            mv $domdir/$folder/.qmail-default $domdir/$folder/.qmail-default.bak
            cp -p .qmail-default $domdir/$folder
            echo "Domain: $folder ready..."
         else
            echo "Skipping $folder..."
         fi
      fi
   done
fi

# Start dspam service
# Start DB server, exit on error
echo "Enabling dspam..."
if [ "$release" = "5" ] || [ "$release" = "6" ]; then
   service dspam start
fi
if [ "$release" = "7" ]; then
  systemctl start dspam.service
fi
if [ "$?" != "0" ]; then
   echo "Dspam not started. Exiting..."
   exit 1
fi

exit 0
